/* VEHICLE FLEET MODEL */
/* Projects the age and technology composition of the vehicle fleet. */
/* High level vehicle types are: lpv = light passenger vehicle, lcv = light*/
/* commercial vehicle, mc = motorcycle, hcv = heavy commercial vehicle, bus*/
/* = bus. */

/*DEVELOPMENT NOTES - revise scrappage calculations - current constant*/
/*should probably be reconsidered. */
mata
/* DIMENSIONS*/
Ps = 2021
Pe = 2050
/*Projection_t = 2021:2050
//Length of historical data series*/
Ts = 1992
Te = 2020
/*Set population series length, history plus projection
*Time_t = 1992:2050*/
Time_length = Pe - Ts + 1
TL = Time_length
Time_t = 1992..2050
/*Length of history
*History_length = length(History_t)*/
History_length = Te - Ts+1
HL = History_length


Fleet_t = 2000..2050
Fleet_projection = Pe-Ps
TL_fleet = cols(Fleet_t)
fleet_input_t = 2000..2020
IL_fleet = cols(fleet_input_t)
PL_fleet = Fleet_projection /*Fleet Projection length (PL)*/
veh_ages_l = (cols(lpv_input))/*Vehicle type and age dimensions*/
veh_ages_str=0..44
veh_ages = veh_ages_l
lpv_types = rows(lpv_input)/IL_fleet
lcv_types = rows(lcv_input)/IL_fleet
mc_types = rows(mc_input)/IL_fleet
hcv_types = rows(hcv_input)/IL_fleet
bus_types = rows(bus_input)/IL_fleet
veh_ages_minus_one = veh_ages_l-1

/* PARAMETERS/ASSUMPTIONS*/
/* Read from the model input data and the model assumptions inputted at the front end, these include */
/* (i)  coefficients for large vehicle proportions in registrations in 'lpv_size_beta'*/
/* (ii) coefficients for income and price impacts on new vehicle purchases */
/* (iii) Assumed growth in used vehicle import ages (1+rate) and standard*/
/* deviation on observed age historical*/
/* (iv) Assumed long run shares of alternative vehicles in registrations*/
/* based on a generalised logistic function i.e. */
/* lpv_reg_share(t) = lpv_reg_share(t-1) + (Target-lpv_reg_share(t-1))/(1+S.e^-b(t-T))^(1/v) */

/* INITIALISE*/

/*LPVs*/
lpv = J(IL_fleet*veh_ages_l,lpv_types,0) /*vehicle stock [in this case light passenger vehicles] */
lpv_reg = J(length(fleet_input_t)*veh_ages,lpv_types,0) /*registrations*/
		lpv_scrap = J(length(fleet_input_t)*veh_ages,lpv_types,0)/* Vehicles scrapped*/
lpv_scrap_rate = J(length(fleet_input_t)*veh_ages,lpv_types,0) /*Vehicles scrapped in year t as a share of year t-1 vehicles*/
lpv_scrap_rate_all_types = J(length(fleet_input_t),veh_ages,0) /* All types is across all fuel technology and engine sizes for a given high level vehicle type*/
lpv_scrap_proj = J(TL_fleet,lpv_types*veh_ages,0)/* Projected numbers of vehicles scrapped*/
lpv_scrap_rate_proj = J(TL_fleet,lpv_types*veh_ages,0) /*Projected scrappage rates*/
lpv_reg_proj = J(TL_fleet,lpv_types*veh_ages,0)/* projected registrations*/
lpv_proj = J(TL_fleet,lpv_types*veh_ages,0)/*projected vehicles*/
lpv_p_survival=J(veh_ages,lpv_types*veh_ages,0) /*diagonal matrix of  survival probabilities*/
T_lpv =J(veh_ages,lpv_types*veh_ages,0)/* transition matrix*/

lpv_replacement_demand = J(TL_fleet,1,0)/*Registrations needed to replace scrapped vehicles*/
lpv_new_demand_proj = J(TL_fleet,veh_ages*lpv_types,0) /*Registrations needed to meet demand growth*/
lpv_reg_shr = J(TL_fleet,veh_ages*lpv_types,0)
lpv_reg_shr_hist = J(IL_fleet,veh_ages*lpv_types,0)
lpv_new_demand_proj_tot = J(TL_fleet,1,0)
lpv_reg_proj_tot = J(TL_fleet,1,0)
lpv_new_demand_proj_types = J(TL_fleet,veh_ages,0)
lpv_proj_all_types = J(TL_fleet, veh_ages,0)


/*LCVs*/
lcv = J(length(fleet_input_t)*veh_ages,lcv_types,0)/*vehicle stock */
lcv_reg = J(length(fleet_input_t)*veh_ages,lcv_types,0)/*registrations */
lcv_scrap = J(length(fleet_input_t)*veh_ages,lcv_types,0)/* Vehicles scrapped */
lcv_scrap_rate = J(length(fleet_input_t)*veh_ages,lcv_types,0)/*Vehicles scrapped in year t as a share of year t-1 vehicles */
lcv_scrap_rate_all_types = J(length(fleet_input_t),veh_ages,0)/* All types is across all fuel technology and engine sizes for a given high level vehicle type */
lcv_scrap_proj = J(TL_fleet,veh_ages*lcv_types,0)/* Projected numbers of vehicles scrapped */
lcv_scrap_rate_proj = J(TL_fleet,veh_ages*lcv_types,0) /*Projected scrappage rates */
lcv_reg_proj = J(TL_fleet,veh_ages*lcv_types,0)/* projected registrations */
lcv_proj = J(TL_fleet,veh_ages*lcv_types,0)/*projected vehicles */
lcv_p_survival=J(veh_ages,veh_ages*lcv_types,0)/*diagonal matrix of  survival probabilities */
T_lcv=J(veh_ages,veh_ages*lcv_types,0)/* transition matrix */
lcv_replacement_demand = J(TL_fleet,1,0)/*Registrations needed to replace scrapped vehicles*/
lcv_new_demand_proj = J(TL_fleet,veh_ages*lcv_types,0) /*Registrations needed to meet demand growth*/
lcv_reg_shr = J(TL_fleet,veh_ages*lcv_types,0)
lcv_reg_shr_hist = J(IL_fleet,veh_ages*lcv_types,0)
lcv_new_demand_proj_tot = J(TL_fleet,1,0)
lcv_reg_proj_tot = J(TL_fleet,1,0)
lcv_new_demand_proj_types = J(TL_fleet,lcv_types,0)
lcv_proj_all_types = J(TL_fleet, veh_ages,0)

/*MCs*/
mc = J(length(fleet_input_t)*veh_ages,mc_types,0)/*vehicle stock */
mc_reg = J(length(fleet_input_t)*veh_ages,mc_types,0)/*registrations*/
mc_scrap = J(length(fleet_input_t)*veh_ages,mc_types,0)/* Vehicles scrapped*/
mc_scrap_rate = J(length(fleet_input_t)*veh_ages,mc_types,0)/*Vehicles scrapped in year t as a share of year t-1 vehicles*/
mc_scrap_rate_all_types = J(length(fleet_input_t),veh_ages,0)/* All types is across all fuel technology and engine sizes for a given high level vehicle type*/
mc_scrap_proj = J(TL_fleet,veh_ages*mc_types,0)/* Projected numbers of vehicles scrapped*/
mc_scrap_rate_proj = J(TL_fleet,veh_ages*mc_types,0) /*Projected scrappage rates*/
mc_reg_proj = J(TL_fleet,veh_ages*mc_types,0)/* projected registrations*/
mc_proj = J(TL_fleet,veh_ages*mc_types,0)/*projected vehicles*/
mc_p_survival=J(veh_ages,veh_ages*mc_types,0)/*diagonal matrix of  survival probabilities*/
T_mc =J(veh_ages,veh_ages*mc_types,0)/* transition matrix*/
mc_replacement_demand = J(TL_fleet,1,0)/*Registrations needed to replace scrapped vehicles*/
mc_new_demand_proj = J(TL_fleet,veh_ages*mc_types,0) /*Registrations needed to meet demand growth*/
mc_reg_shr = J(TL_fleet,veh_ages*mc_types,0)
mc_reg_shr_hist = J(IL_fleet,veh_ages*mc_types,0)
mc_new_demand_proj_tot = J(TL_fleet,1,0)
mc_reg_proj_tot = J(TL_fleet,1,0)
mc_new_demand_proj_types = J(TL_fleet,veh_ages,0)
mc_proj_all_types = J(TL_fleet, veh_ages,0)

/*HCVs*/
hcv = J(length(fleet_input_t)*veh_ages,hcv_types,0)/*vehicle stock */
hcv_reg = J(length(fleet_input_t)*veh_ages,hcv_types,0)/*registrations*/
hcv_scrap = J(length(fleet_input_t)*veh_ages,hcv_types,0)/* Vehicles scrapped*/
hcv_scrap_rate = J(length(fleet_input_t)*veh_ages,hcv_types,0)/*Vehicles scrapped in year t as a share of year t-1 vehicles*/
hcv_scrap_rate_all_types = J(length(fleet_input_t),veh_ages,0)/* All types is across all fuel technology and engine sizes for a given high level vehicle type*/
hcv_scrap_proj = J(TL_fleet,veh_ages*hcv_types,0)/* Projected numbers of vehicles scrapped*/
hcv_scrap_rate_proj = J(TL_fleet,veh_ages*hcv_types,0) /*Projected scrappage rates*/
hcv_reg_proj = J(TL_fleet,veh_ages*hcv_types,0)/* projected registrations*/
hcv_proj = J(TL_fleet,veh_ages*hcv_types,0)/*projected vehicles*/
hcv_p_survival=J(veh_ages,veh_ages*hcv_types,0)/*diagonal matrix of  survival probabilities*/
T_hcv=J(veh_ages,veh_ages*hcv_types,0)/* transition matrix*/
hcv_replacement_demand = J(TL_fleet,1,0)/*Registrations needed to replace scrapped vehicles*/
hcv_new_demand_proj = J(TL_fleet,veh_ages*hcv_types,0) /*Registrations needed to meet demand growth*/
hcv_reg_shr = J(TL_fleet,veh_ages*hcv_types,0)
hcv_reg_shr_hist = J(IL_fleet,veh_ages*hcv_types,0)
hcv_new_demand_proj_tot = J(TL_fleet,1,0)
hcv_reg_proj_tot = J(TL_fleet,1,0)
hcv_new_demand_proj_types = J(TL_fleet,veh_ages,0)
hcv_proj_all_types = J(TL_fleet, veh_ages,0)

/*BUSs*/
bus = J(length(fleet_input_t)*veh_ages,bus_types,0)/*vehicle stock */
bus_reg = J(length(fleet_input_t)*veh_ages,bus_types,0)/*registrations*/
bus_scrap = J(length(fleet_input_t)*veh_ages,bus_types,0)/* Vehicles scrapped*/
bus_scrap_rate = J(length(fleet_input_t)*veh_ages,bus_types,0)/*Vehicles scrapped in year t as a share of year t-1 vehicles*/
bus_scrap_rate_all_types = J(length(fleet_input_t),veh_ages,0)/* All types is across all fuel technology and engine sizes for a given high level vehicle type*/
bus_scrap_proj = J(TL_fleet,veh_ages*bus_types,0)/* Projected numbers of vehicles scrapped*/
bus_scrap_rate_proj = J(TL_fleet,veh_ages*bus_types,0) /*Projected scrappage rates*/
bus_reg_proj = J(TL_fleet,veh_ages*bus_types,0)/* projected registrations*/
bus_proj = J(TL_fleet,veh_ages*bus_types,0)/*projected vehicles*/
bus_p_survival=J(veh_ages,veh_ages*bus_types,0)/*diagonal matrix of  survival probabilities*/
T_bus=J(veh_ages,veh_ages*bus_types,0)/* transition matrix*/
bus_replacement_demand = J(TL_fleet,1,0)/*Registrations needed to replace scrapped vehicles*/
bus_new_demand_proj = J(TL_fleet,veh_ages*bus_types,0) /*Registrations needed to meet demand growth*/
bus_reg_shr = J(TL_fleet,veh_ages*bus_types,0)
bus_reg_shr_hist = J(IL_fleet,veh_ages*bus_types,0)
bus_new_demand_proj_tot = J(TL_fleet,1,0)
bus_reg_proj_tot = J(TL_fleet,1,0)
bus_new_demand_proj_types = J(TL_fleet,veh_ages,0)
bus_proj_all_types = J(TL_fleet, veh_ages,0)

/* PREPARE MULTIDIMENSIONAL FLEET DATA */
/* Involves:*/
/* (1) 2D Matrices (t * age, type)*/
/* (2) Calculating scrappage numbers and rates*/


/*LPVs*/
/*
lpv= J(IL_fleet*veh_ages,lpv_types,0)
for (i=1; i< IL_fleet; i++){
for (j=1; j<=lpv_types; j++) {
for (h=1; h<=veh_ages; h++){
    lpv[(i-1)*veh_ages+h, j]=lpv_input[(j-1)*IL_fleet+i,h]
}
}
}

lpv_reg= J(IL_fleet*veh_ages,lpv_types,0)
for (i=1; i< IL_fleet; i++){
for (j=1; j<=lpv_types; j++) {
for (h=1; h<=veh_ages; h++){
    lpv_reg[(i-1)*veh_ages+h, j]=lpv_reg_input[(j-1)*IL_fleet+i,h]
}
}
}

lpv_all_sum = rowsum(lpv)
lpv_all = rowshape(lpv_all_sum, IL_fleet)


for (i=1; i< IL_fleet; i++){
	for (h=2; h<veh_ages; h++){
		lpv_scrap[(i)*(veh_ages)+h,.] = lpv[(i-1)*(veh_ages-1)+h-1,.] + lpv_reg[(i)*(veh_ages)+h,.]-lpv[(i)*(veh_ages)+h,.]


}
}
lpv_all_sum = rowsum(lpv)
lpv_all_types = rowshape(lpv_all_sum, IL_fleet)
*/
lpv= J(IL_fleet,lpv_types*veh_ages,0)
lpv_reg = J(IL_fleet,lpv_types*veh_ages,0)
lpv_scrap= J(IL_fleet,lpv_types*veh_ages,0)
lpv_scrap_rate= J(IL_fleet,lpv_types*veh_ages,0)

for (i=1; i<= lpv_types; i++){
	 lpv[1..IL_fleet,(i-1)*veh_ages+1..i*veh_ages] = lpv_input[((i-1)*IL_fleet+1)..(i*IL_fleet),1..veh_ages]
	 lpv_reg[1..IL_fleet,(i-1)*veh_ages+1..i*veh_ages] = lpv_reg_input[(i-1)*IL_fleet+1..i*IL_fleet,.]
}
lpv_all_types = J(IL_fleet, veh_ages, 0)
for (i=1; i<= lpv_types; i++){
	lpv_all_types[1..IL_fleet,1..veh_ages] = lpv[1..IL_fleet,(i-1)*veh_ages+1..i*veh_ages] + lpv_all_types[1..IL_fleet,1..veh_ages]
}

for (j=1; j<=lpv_types; j++) {
	lpv_scrap[2..rows(lpv_scrap),(j-1)*veh_ages+2..veh_ages]= lpv[1..rows(lpv_scrap)-1,(j-1)*veh_ages+1..veh_ages-1]+lpv_reg[2..rows(lpv_scrap),(j-1)*veh_ages+2..veh_ages]-lpv[2..rows(lpv_scrap),(j-1)*veh_ages+2..veh_ages]
}
/*
lpv_sc0 = rowshape(lpv, veh_ages)
lpv_sc1 = lpv_sc0[1..veh_ages-1,1..cols(lpv_sc0)-lpv_types]
lpv_sc2 = lpv_sc0[2..veh_ages,lpv_types+1..cols(lpv_sc0)]
lpv_reg_sc0 = rowshape(lpv_reg, veh_ages)
lpv_reg_sc1 = lpv_reg_sc0[2..veh_ages,lpv_types+1..cols(lpv_reg_sc0)]
lpv_scr1 = colshape(lpv_sc1, lpv_types)
lpv_scr2 = colshape(lpv_sc2, lpv_types)
lpv_reg_scr1 = colshape(lpv_reg_sc1, lpv_types)
*/


/*LCVs*/

lcv= J(IL_fleet,lcv_types*veh_ages,0)
lcv_reg = J(IL_fleet,lcv_types*veh_ages,0)
lcv_scrap= J(IL_fleet,lcv_types*veh_ages,0)
lcv_scrap_rate= J(IL_fleet,lcv_types*veh_ages,0)

for (i=1; i<= lcv_types; i++){
	 lcv[1..IL_fleet,(i-1)*veh_ages_l+1..i*veh_ages_l] = lcv_input[(i-1)*IL_fleet+1..i*IL_fleet,.]
	 lcv_reg[1..IL_fleet,(i-1)*veh_ages_l+1..i*veh_ages_l] = lcv_reg_input[(i-1)*IL_fleet+1..i*IL_fleet,.]
}
lcv_all_types = J(IL_fleet, veh_ages, 0)
for (i=1; i<= lcv_types; i++){
	lcv_all_types[1..IL_fleet,1..veh_ages] = lcv[1..IL_fleet,(i-1)*veh_ages+1..i*veh_ages] + lcv_all_types[1..IL_fleet,1..veh_ages]
}

for (j=1; j<=lcv_types; j++) {
	lcv_scrap[2..rows(lcv_scrap),(j-1)*veh_ages+2..veh_ages]= lcv[1..rows(lcv_scrap)-1,(j-1)*veh_ages+1..veh_ages-1]+lcv_reg[2..rows(lcv_scrap),(j-1)*veh_ages+2..veh_ages]-lcv[2..rows(lcv_scrap),(j-1)*veh_ages+2..veh_ages]
}

/*MCs*/

mc= J(IL_fleet,mc_types*veh_ages,0)
mc_reg = J(IL_fleet,mc_types*veh_ages,0)
mc_scrap= J(IL_fleet,mc_types*veh_ages,0)
mc_scrap_rate= J(IL_fleet,mc_types*veh_ages,0)

for (i=1; i<= mc_types; i++){
	 mc[1..IL_fleet,(i-1)*veh_ages+1..i*veh_ages] = mc_input[(i-1)*IL_fleet+1..i*IL_fleet,.]
	 mc_reg[1..IL_fleet,(i-1)*veh_ages+1..i*veh_ages] = mc_reg_input[(i-1)*IL_fleet+1..i*IL_fleet,.]
}
mc_all_types = J(IL_fleet, veh_ages, 0)
for (i=1; i<= mc_types; i++){
	mc_all_types[1..IL_fleet,1..veh_ages] = mc[1..IL_fleet,(i-1)*veh_ages+1..i*veh_ages] + mc_all_types[1..IL_fleet,1..veh_ages]
}

for (j=1; j<=mc_types; j++) {
	mc_scrap[2..rows(mc_scrap),(j-1)*veh_ages+2..veh_ages]= mc[1..rows(mc_scrap)-1,(j-1)*veh_ages+1..veh_ages-1]+mc_reg[2..rows(mc_scrap),(j-1)*veh_ages+2..veh_ages]-mc[2..rows(mc_scrap),(j-1)*veh_ages+2..veh_ages]
}


/*HCVs*/
hcv= J(IL_fleet,hcv_types*veh_ages,0)
hcv_reg = J(IL_fleet,hcv_types*veh_ages,0)
hcv_scrap= J(IL_fleet,hcv_types*veh_ages,0)
hcv_scrap_rate= J(IL_fleet,hcv_types*veh_ages,0)

for (i=1; i<= hcv_types; i++){
	 hcv[1..IL_fleet,(i-1)*veh_ages_l+1..i*veh_ages_l] = hcv_input[(i-1)*IL_fleet+1..i*IL_fleet,.]
	 hcv_reg[1..IL_fleet,(i-1)*veh_ages_l+1..i*veh_ages_l] = hcv_reg_input[(i-1)*IL_fleet+1..i*IL_fleet,.]
}
hcv_all_types = J(IL_fleet, veh_ages, 0)
for (i=1; i<= hcv_types; i++){
	hcv_all_types[1..IL_fleet,1..veh_ages] = hcv[1..IL_fleet,(i-1)*veh_ages+1..i*veh_ages] + hcv_all_types[1..IL_fleet,1..veh_ages]
}

for (j=1; j<=hcv_types; j++) {
	hcv_scrap[2..rows(hcv_scrap),(j-1)*veh_ages+2..veh_ages]= hcv[1..rows(hcv_scrap)-1,(j-1)*veh_ages+1..veh_ages-1]+hcv_reg[2..rows(hcv_scrap),(j-1)*veh_ages+2..veh_ages]-hcv[2..rows(hcv_scrap),(j-1)*veh_ages+2..veh_ages]
}


/*BUSs*/
bus= J(IL_fleet,bus_types*veh_ages,0)
bus_reg = J(IL_fleet,bus_types*veh_ages,0)
bus_scrap= J(IL_fleet,bus_types*veh_ages,0)
bus_scrap_rate= J(IL_fleet,bus_types*veh_ages,0)

for (i=1; i<= bus_types; i++){
	 bus[1..IL_fleet,(i-1)*veh_ages_l+1..i*veh_ages_l] = bus_input[(i-1)*IL_fleet+1..i*IL_fleet,.]
	 bus_reg[1..IL_fleet,(i-1)*veh_ages_l+1..i*veh_ages_l] = bus_reg_input[(i-1)*IL_fleet+1..i*IL_fleet,.]
}
bus_all_types = J(IL_fleet, veh_ages, 0)
for (i=1; i<= bus_types; i++){
	bus_all_types[1..IL_fleet,1..veh_ages] = bus[1..IL_fleet,(i-1)*veh_ages+1..i*veh_ages] + bus_all_types[1..IL_fleet,1..veh_ages]
}

for (j=1; j<=bus_types; j++) {
	bus_scrap[2..rows(bus_scrap),(j-1)*veh_ages+2..veh_ages]= bus[1..rows(bus_scrap)-1,(j-1)*veh_ages+1..veh_ages-1]+bus_reg[2..rows(bus_scrap),(j-1)*veh_ages+2..veh_ages]-bus[2..rows(bus_scrap),(j-1)*veh_ages+2..veh_ages]
}

/*Calculating scrappage numbers and rates*/

/*LPVs*/
/*Calculate scrap rates for lpv (t,age,type)*/

lpv_scrap =(lpv_scrap :>= 0) :* lpv_scrap
for (j=1; j<lpv_types; j++) {
	lpv_scrap_rate[1..rows(lpv_scrap_rate)-1,(j-1)*veh_ages+1..veh_ages-1]= lpv_scrap[2..rows(lpv_scrap),(j-1)*veh_ages+2..veh_ages]:/lpv[1..rows(lpv)-1,(j-1)*veh_ages+1..veh_ages-1]
}
lpv_scrap_rate =(lpv_scrap_rate :<= 1) :* lpv_scrap_rate
/*Note that the missing values may need to change earlier*/
lpv_scrap_rate=editmissing(lpv_scrap_rate,0)

/*
for (i=1; i< IL_fleet; i++){
	for (h=2; h<veh_ages; h++){
lpv_scrap_rate[(i-1)*(veh_ages-1)+h-1,.]=lpv_scrap[(i)*(veh_ages)+h,.]:/lpv[(i-1)*(veh_ages-1)+h-1,.]
}
}
lpv_scrap_sum = J(IL_fleet,veh_ages,0)
lpv_all_sum = rowsum(lpv)
lpv_scrap_sum0 = colshape(lpv_scrap,veh_ages)
for (i=1; i< IL_fleet; i++){
	lpv_scrap_sum[i,1..veh_ages] = colsum(lpv_scrap_sum0[(i-1)*lpv_types+1..lpv_types*i,.])
}
lpv_scrap_rate_all_types[1..rows(lpv_scrap_rate_all_types)-1,1..veh_ages-1]= lpv_scrap_all_types[2..rows(lpv_scrap_all_types),2..veh_ages]:/lpv_all_types[1..rows(lpv_all_types)-1,1..veh_ages-1]

	lpv_scrap_sum = rowsum(lpv_scrap)
	lpv_scrap_all_types = rowshape(lpv_scrap_sum, IL_fleet)
*/

/*Calculate scrap rates for lpv all types (t,age)*/

/*lpv_all_types = rowshape(lpv_all_sum, IL_fleet)*/
lpv_scrap_all_types = J(IL_fleet, veh_ages,0)
for (i=1; i< lpv_types; i++){
	lpv_scrap_all_types[1..IL_fleet,1..veh_ages] = lpv_scrap[1..IL_fleet,(i-1)*veh_ages+1..i*veh_ages] + lpv_scrap_all_types[1..IL_fleet,1..veh_ages]
}
lpv_scrap_rate_all_types[1..rows(lpv_scrap_rate_all_types)-1,1..veh_ages-1]= lpv_scrap_all_types[2..rows(lpv_scrap_all_types),2..veh_ages]:/lpv_all_types[1..rows(lpv_all_types)-1,1..veh_ages-1]
lpv_scrap_rate_all_types =(lpv_scrap_rate_all_types:<= 1) :* lpv_scrap_rate_all_types
/*Calculate average lpv scrappage age, ignoring ages beyond 32 (truncated)*/
lpv_ave_scrap_age = (lpv_scrap_rate_all_types[.,1..33]*veh_ages_str[.,1..33]'):/rowsum(lpv_scrap_rate_all_types[.,1..33])


/*LCVs*/
/*Calculate scrap rates for lcv (t,age,type)*/

lcv_scrap =(lcv_scrap :>= 0) :* lcv_scrap
for (j=1; j<lcv_types; j++) {
	lcv_scrap_rate[1..rows(lcv_scrap_rate)-1,(j-1)*veh_ages+1..veh_ages-1]= lcv_scrap[2..rows(lcv_scrap),(j-1)*veh_ages+2..veh_ages]:/lcv[1..rows(lcv)-1,(j-1)*veh_ages+1..veh_ages-1]
}
lcv_scrap_rate =(lcv_scrap_rate :<= 1) :* lcv_scrap_rate
/*Calculate scrap rates for lcv all types (t,age)*/
/*lcv_all_types = rowshape(lcv_all_sum, IL_fleet)*/
lcv_scrap_rate=editmissing(lcv_scrap_rate,0)

lcv_scrap_all_types = J(IL_fleet, veh_ages,0)
for (i=1; i< lcv_types; i++){
	lcv_scrap_all_types[1..IL_fleet,1..veh_ages] = lcv_scrap[1..IL_fleet,(i-1)*veh_ages+1..i*veh_ages] + lcv_scrap_all_types[1..IL_fleet,1..veh_ages]
}
lcv_scrap_rate_all_types[1..rows(lcv_scrap_rate_all_types)-1,1..veh_ages-1]= lcv_scrap_all_types[2..rows(lcv_scrap_all_types),2..veh_ages]:/lcv_all_types[1..rows(lcv_all_types)-1,1..veh_ages-1]
lcv_scrap_rate_all_types =(lcv_scrap_rate_all_types:<= 1) :* lcv_scrap_rate_all_types
/*Calculate average lcv scrappage age, ignoring ages beyond 32 (truncated)*/
lcv_ave_scrap_age = (lcv_scrap_rate_all_types[.,1..33]*veh_ages_str[.,1..33]'):/rowsum(lcv_scrap_rate_all_types[.,1..33])

/*MCs*/
/*Calculate scrap rates for mc (t,age,type)*/

mc_scrap =(mc_scrap :>= 0) :* mc_scrap
for (j=1; j<mc_types; j++) {
	mc_scrap_rate[1..rows(mc_scrap_rate)-1,(j-1)*veh_ages+1..veh_ages-1]= mc_scrap[2..rows(mc_scrap),(j-1)*veh_ages+2..veh_ages]:/mc[1..rows(mc)-1,(j-1)*veh_ages+1..veh_ages-1]
}
mc_scrap_rate =(mc_scrap_rate :<= 1) :* mc_scrap_rate
/*Calculate scrap rates for mc all types (t,age)*/
/*mc_all_types = rowshape(mc_all_sum, IL_fleet)*/
mc_scrap_rate=editmissing(mc_scrap_rate,0)

mc_scrap_all_types = J(IL_fleet, veh_ages,0)
for (i=1; i< mc_types; i++){
	mc_scrap_all_types[1..IL_fleet,1..veh_ages] = mc_scrap[1..IL_fleet,(i-1)*veh_ages+1..i*veh_ages] + mc_scrap_all_types[1..IL_fleet,1..veh_ages]
}
mc_scrap_rate_all_types[1..rows(mc_scrap_rate_all_types)-1,1..veh_ages-1]= mc_scrap_all_types[2..rows(mc_scrap_all_types),2..veh_ages]:/mc_all_types[1..rows(mc_all_types)-1,1..veh_ages-1]
mc_scrap_rate_all_types =(mc_scrap_rate_all_types:<= 1) :* mc_scrap_rate_all_types
/*Calculate average mc scrappage age, ignoring ages beyond 32 (truncated)*/
mc_ave_scrap_age = (mc_scrap_rate_all_types[.,1..33]*veh_ages_str[.,1..33]'):/rowsum(mc_scrap_rate_all_types[.,1..33])

/*HCVs*/
/*Calculate scrap rates for hcv (t,age,type)*/

hcv_scrap =(hcv_scrap :>= 0) :* hcv_scrap
for (j=1; j<hcv_types; j++) {
	hcv_scrap_rate[1..rows(hcv_scrap_rate)-1,(j-1)*veh_ages+1..veh_ages-1]= hcv_scrap[2..rows(hcv_scrap),(j-1)*veh_ages+2..veh_ages]:/hcv[1..rows(hcv)-1,(j-1)*veh_ages+1..veh_ages-1]
}
hcv_scrap_rate =(hcv_scrap_rate :<= 1) :* hcv_scrap_rate
hcv_scrap_rate=editmissing(hcv_scrap_rate,0)

/*Calculate scrap rates for hcv all types (t,age)*/
/*hcv_all_types = rowshape(hcv_all_sum, IL_fleet)*/
hcv_scrap_all_types = J(IL_fleet, veh_ages,0)
for (i=1; i< hcv_types; i++){
	hcv_scrap_all_types[1..IL_fleet,1..veh_ages] = hcv_scrap[1..IL_fleet,(i-1)*veh_ages+1..i*veh_ages] + hcv_scrap_all_types[1..IL_fleet,1..veh_ages]
}
hcv_scrap_rate_all_types[1..rows(hcv_scrap_rate_all_types)-1,1..veh_ages-1]= hcv_scrap_all_types[2..rows(hcv_scrap_all_types),2..veh_ages]:/hcv_all_types[1..rows(hcv_all_types)-1,1..veh_ages-1]
hcv_scrap_rate_all_types =(hcv_scrap_rate_all_types:<= 1) :* hcv_scrap_rate_all_types
/*Calculate average hcv scrappage age, ignoring ages beyond 32 (truncated)*/
hcv_ave_scrap_age = (hcv_scrap_rate_all_types[.,1..33]*veh_ages_str[.,1..33]'):/rowsum(hcv_scrap_rate_all_types[.,1..33])

/*BUSs*/
/*Calculate scrap rates for bus (t,age,type)*/

bus_scrap =(bus_scrap :>= 0) :* bus_scrap
for (j=1; j<bus_types; j++) {
	bus_scrap_rate[1..rows(bus_scrap_rate)-1,(j-1)*veh_ages+1..veh_ages-1]= bus_scrap[2..rows(bus_scrap),(j-1)*veh_ages+2..veh_ages]:/bus[1..rows(bus)-1,(j-1)*veh_ages+1..veh_ages-1]
}
bus_scrap_rate =(bus_scrap_rate :<= 1) :* bus_scrap_rate
bus_scrap_rate=editmissing(bus_scrap_rate,0)

/*Calculate scrap rates for bus all types (t,age)*/
/*bus_all_types = rowshape(bus_all_sum, IL_fleet)*/
bus_scrap_all_types = J(IL_fleet, veh_ages,0)
for (i=1; i< bus_types; i++){
	bus_scrap_all_types[1..IL_fleet,1..veh_ages] = bus_scrap[1..IL_fleet,(i-1)*veh_ages+1..i*veh_ages] + bus_scrap_all_types[1..IL_fleet,1..veh_ages]
}
bus_scrap_rate_all_types[1..rows(bus_scrap_rate_all_types)-1,1..veh_ages-1]= bus_scrap_all_types[2..rows(bus_scrap_all_types),2..veh_ages]:/bus_all_types[1..rows(bus_all_types)-1,1..veh_ages-1]
bus_scrap_rate_all_types =(bus_scrap_rate_all_types:<= 1) :* bus_scrap_rate_all_types
/*Calculate average bus scrappage age, ignoring ages beyond 32 (truncated)*/
bus_ave_scrap_age = (bus_scrap_rate_all_types[.,1..33]*veh_ages_str[.,1..33]'):/rowsum(bus_scrap_rate_all_types[.,1..33])



/* PROJECT FLEET SCRAP RATES AND REGISTRATIONS*/

/* 1. LPVs*/

/* (a)Scrappage */
/*Note: the new update should change the matrix size for lpv_scrap rate and lpv_scrap_rate_proj in the next 4 lines*/
lpv_scrap_rate_proj[1..IL_fleet-1,.]= lpv_scrap_rate[1..20,.]
lpv_scrap_constant = (lpv_scrap_rate[19,.]+lpv_scrap_rate[20,.])*0.5
lpv_scrap_rate_proj[IL_fleet..rows(lpv_scrap_rate_proj),.] = J(TL_fleet-IL_fleet+1, 1, lpv_scrap_constant)
lpv_survival_proj = 1:-lpv_scrap_rate_proj
lpv_survival_proj=editmissing(lpv_survival_proj,0)


/* lpv_scrap_rate_proj(1:IL_fleet,:,:) = lpv_scrap_rate; */
/* lpv_scrap_constant = (lpv_scrap_rate(8,:,:)+lpv_scrap_rate(9,:,:))*0.5; */
/* lpv_scrap_rate_proj(11:end,:,:) = repmat(lpv_scrap_constant,[32 1 1]); */
/* lpv_survival_proj = 1-lpv_scrap_rate_proj; */

/* (b) Registrations */
/* (i) Preliminaries  */
/* Includes set up for naive forecast if needed (i.e. reg based on history) - not used in the current configuration of the model */
lpv_reg_proj = J(TL_fleet, lpv_types*veh_ages,0)
lpv_reg_proj[1..IL_fleet,.] = lpv_reg
lpv_reg_constant = (lpv_reg[8,.]+lpv_reg[9,.])*0.5
lpv_reg_proj[IL_fleet+1..rows(lpv_reg_proj),.] = J(TL_fleet-IL_fleet, 1, lpv_reg_constant)

lpv_reg_hist_total = rowsum(lpv_reg)
lpv_reg_shr_constant = lpv_reg[5,.]:/ lpv_reg_hist_total[5] /*To be varied by scenario*/
lpv_reg_shr_hist = lpv_reg:/lpv_reg_hist_total 

/*lpv_reg_shock = 1 /*Shocking registrations in a given year*/
lpv_reg_proj(21,6:9,:) = lpv_reg_proj(15,6:9,:)*lpv_reg_shock; /* this isnt used with the impact of the HH model - however it could be moved below to create a bespoke shock outside the HH model*/ */
lpv_proj[1,.] = lpv[1,.] /*initialising projection for year 2000 */
lpv_reg_proj_tot[1,.] = rowsum(lpv_reg[1,.]) /*initialising projection for year 2000 */

/* (ii) Project vehicle sizes: small vs large */
lpv_reg_small_hist = J(TL_fleet,1,0)
lpv_reg_small_hist = rowsum(lpv_reg_proj[.,1..veh_ages])+rowsum(lpv_reg_proj[.,veh_ages+1..2*veh_ages])+rowsum(lpv_reg_proj[.,veh_ages*5+1..6*veh_ages])+rowsum(lpv_reg_proj[.,veh_ages*6+1..veh_ages*7])

lpv_reg_shr_proj = lpv_reg_shr_hist\ J(PL_fleet+1, 1, lpv_reg_shr_constant) /*Constant market share of new registrations by age and type - to be overwritten but available if needed */
lpv_reg_lrg_hist = rowsum(lpv_reg_proj[.,veh_ages*2+1..veh_ages*3])+rowsum(lpv_reg_proj[.,veh_ages*3+1..4*veh_ages])+rowsum(lpv_reg_proj[.,veh_ages*4+1..5*veh_ages])+rowsum(lpv_reg_proj[.,veh_ages*7+1..veh_ages*8]) +rowsum(lpv_reg_proj[.,veh_ages*8+1..veh_ages*9])
/* Calculate historical shars of large vehicles (M,L,XL) */
lpv_reg_lrg_shr_hist = lpv_reg_lrg_hist[1..IL_fleet]:/lpv_reg_hist_total /* Calculate share in total registrations*/
lpv_reg_lrg_shr_proj = (lpv_reg_lrg_shr_hist[1..IL_fleet]\J(PL_fleet+1,1,0)) /*Initialise projection series for large vehicles share of registrations*/
/*exogenous variables for projection*/
lpv_lrg_exog = (price_to_gdp,gdp_vol_fcast)
/*Model-based projections (linear version)*/
lpv_lrg_i = lpv_lrg_exog*lpv_size_beta
/*Transform to log model*/
lpv_lrg_shr_fit = exp(lpv_lrg_i):/(1:+exp(lpv_lrg_i)) 
/*Calcualte growth rate of fitted proportions - to smooth from actuals to*/
/*model results*/
lpv_lrg_shr_fit_growth = J(TL,1,0)
lpv_lrg_shr_fit_growth[2..TL] = diff(lpv_lrg_shr_fit):/lpv_lrg_shr_fit[1..rows(lpv_lrg_shr_fit)-1]
/*Calculate final fitted forecast proportions*/
for (i=IL_fleet+1; i<=TL_fleet; i++) {
lpv_reg_lrg_shr_proj[i] = lpv_reg_lrg_shr_proj[i-1]:*(1:+lpv_lrg_shr_fit_growth[i+8])
}
lpv_reg_small_shr_proj = 1:-lpv_reg_lrg_shr_proj

/* (iii) Alternative fuel vehicles*/
/*Calculates shares based on assumed growth of alternative vehicles*/
/*All alternative vehicles*/
lpv_reg_alt_hist = rowsum(lpv_reg_proj[.,veh_ages*10+1..veh_ages*11])+rowsum(lpv_reg_proj[.,veh_ages*11+1..12*veh_ages])+rowsum(lpv_reg_proj[.,veh_ages*12+1..13*veh_ages]) 
lpv_reg_alt_shr_proj = (lpv_reg_alt_hist[1..IL_fleet]:/lpv_reg_hist_total\J(TL_fleet-IL_fleet,1,0))

/* Hybrid vehicles*/
lpv_reg_hybrid_hist = rowsum(lpv_reg_proj[.,veh_ages*10+1..veh_ages*11])
lpv_reg_hybrid_alt_shr_proj = (lpv_reg_hybrid_hist[1..IL_fleet]:/lpv_reg_alt_hist[1..IL_fleet]\J(TL_fleet-IL_fleet,1,0))
lpv_reg_hybrid_shr_proj = (lpv_reg_hybrid_hist[1..IL_fleet]:/lpv_reg_hist_total\J(TL_fleet-IL_fleet,1,0))

/* Plug-in hybrid vehicles*/
lpv_reg_plugin_hist = rowsum(lpv_reg_proj[.,veh_ages*11+1..veh_ages*12])
lpv_reg_plugin_alt_shr_proj = (lpv_reg_plugin_hist[1..IL_fleet]:/lpv_reg_alt_hist[1..IL_fleet]\J(TL_fleet-IL_fleet,1,0))
lpv_reg_plugin_shr_proj = (lpv_reg_plugin_hist[1..IL_fleet]:/lpv_reg_hist_total\J(TL_fleet-IL_fleet,1,0))
lpv_reg_plugin_alt_shr_proj[11,1] = .01 /*initialising plugin hybrid - seeing as there were none in history*/

/* Electric vehicles*/
lpv_reg_electric_hist = rowsum(lpv_reg_proj[.,veh_ages*12+1..veh_ages*13])
lpv_reg_electric_alt_shr_proj = (lpv_reg_plugin_hist[1..IL_fleet]:/lpv_reg_alt_hist[1..IL_fleet]\J(TL_fleet-IL_fleet,1,0))
lpv_reg_electric_shr_proj = (lpv_reg_electric_hist[1..IL_fleet]:/lpv_reg_hist_total\J(TL_fleet-IL_fleet,1,0))


for (i=IL_fleet+1; i<=TL_fleet;i++){
    lpv_reg_alt_shr_proj[i] = lpv_reg_alt_shr_proj[i-1] + (lpv_alt_target-lpv_reg_alt_shr_proj[i-1])/((1+lpv_alt_S:*exp(-lpv_alt_b:*((i-11)-lpv_alt_T)))^(1/lpv_alt_v))
    lpv_reg_plugin_alt_shr_proj[i] = lpv_reg_plugin_alt_shr_proj[i-1] + (lpv_reg_plugin_target_shr-lpv_reg_plugin_alt_shr_proj[i-1])/((1+lpv_alt_S:*exp(-lpv_alt_b:*((i-11)-lpv_plugin_T)))^(1/lpv_alt_v))
    lpv_reg_electric_alt_shr_proj[i] = lpv_reg_electric_alt_shr_proj[i-1] + (lpv_reg_electric_target_shr-lpv_reg_electric_alt_shr_proj[i-1])/((1+lpv_alt_S:*exp(-lpv_alt_b:*((i-11)-lpv_electric_T)))^(1/lpv_alt_v))
    lpv_reg_hybrid_alt_shr_proj[i] = 1-(lpv_reg_plugin_alt_shr_proj[i]+lpv_reg_electric_alt_shr_proj[i])
    lpv_reg_hybrid_shr_proj[i]= lpv_reg_hybrid_alt_shr_proj[i]:*lpv_reg_alt_shr_proj[i]
    lpv_reg_plugin_shr_proj[i] = lpv_reg_plugin_alt_shr_proj[i]:*lpv_reg_alt_shr_proj[i]
    lpv_reg_electric_shr_proj[i] = lpv_reg_electric_alt_shr_proj[i]:*lpv_reg_alt_shr_proj[i]
}

/* (iv) Combine projections of small-large-and alternative fuel vehicles*/
/*Subtract alternative vehicle growth from small and large vehicle shares in*/
/*proportion to total vehicles (i.e. size neutral)*/
lpv_small_wght = lpv_reg_small_shr_proj[IL_fleet+1..TL_fleet]
lpv_reg_small_shr_proj[IL_fleet+1..TL_fleet] = lpv_reg_small_shr_proj[IL_fleet+1..TL_fleet] - (lpv_small_wght:*lpv_reg_alt_shr_proj[IL_fleet+1..TL_fleet])
lpv_reg_lrg_shr_proj[IL_fleet+1..TL_fleet] = lpv_reg_lrg_shr_proj[IL_fleet+1..TL_fleet] - ((1:-lpv_small_wght):*lpv_reg_alt_shr_proj[IL_fleet+1..TL_fleet])


/* (v) Calculate shares within each category */
/*i.e. distributions within small and large - being that alternative fuel shares are calculated*/
/*directly by assumption) The target is to fill out the following matrix...*/
lpv_reg_shr_by_type = J(TL_fleet,13,0)

/*Calcuate constant proportions within each size type and replicate*/
lpv_reg_small_constant = (rowsum(lpv_reg[11,1..veh_ages*1]):/lpv_reg_small_hist[11],rowsum(lpv_reg[11,veh_ages*1+1..veh_ages*2]):/lpv_reg_small_hist[11],rowsum(lpv_reg[11,veh_ages*5+1..veh_ages*6]):/lpv_reg_small_hist[11],rowsum(lpv_reg[11,veh_ages*6+1..veh_ages*7]):/lpv_reg_small_hist[11])
lpv_reg_lrg_constant = (rowsum(lpv_reg[11,veh_ages*2+1..veh_ages*3]):/lpv_reg_lrg_hist[11],rowsum(lpv_reg[11,veh_ages*3+1..veh_ages*4]):/lpv_reg_lrg_hist[11],rowsum(lpv_reg[11,veh_ages*4+1..veh_ages*5]):/lpv_reg_lrg_hist[11],rowsum(lpv_reg[11,veh_ages*7+1..veh_ages*8]):/lpv_reg_lrg_hist[11],rowsum(lpv_reg[11,veh_ages*8+1..veh_ages*9]):/lpv_reg_lrg_hist[11],rowsum(lpv_reg[11,veh_ages*9+1..veh_ages*10]):/lpv_reg_lrg_hist[11])

/*Small vehicles*/
lpv_reg_shr_by_type[.,1..2] = lpv_reg_small_shr_proj*lpv_reg_small_constant[.,1..2] /*Petrol*/
lpv_reg_shr_by_type[.,6..7] = lpv_reg_small_shr_proj*lpv_reg_small_constant[.,3..4] /* Diesel*/

/*Large vehicles*/
lpv_reg_shr_by_type[.,3..5] = lpv_reg_lrg_shr_proj*lpv_reg_lrg_constant[.,1..3] /*Petrol*/
lpv_reg_shr_by_type[.,8..10] = lpv_reg_lrg_shr_proj*lpv_reg_lrg_constant[.,4..6] /*Diesel*/

/*Alternative fuel vehicles*/
lpv_reg_shr_by_type[.,11..13] = (lpv_reg_hybrid_shr_proj,lpv_reg_plugin_shr_proj,lpv_reg_electric_shr_proj)

/* (vi) Project shares which are new and used */
/*Share of new vehicles in lpv registrations*/
lpv_new_reg_hist = J(IL_fleet,1,0)
for (h=1; h<=IL_fleet; h++){
	for (j=1; j<=13; j++){
	lpv_new_reg_hist[h] = lpv_reg[h,(j-1)*veh_ages+1] + lpv_new_reg_hist[h]
}
}
lpv_new_reg_shr_hist = lpv_new_reg_hist:/lpv_reg_hist_total
lpv_new_reg_shr_proj = (lpv_new_reg_shr_hist\J(PL_fleet+1,1,0))

for (i=IL_fleet+1;i<=TL_fleet;i++){
    lpv_new_reg_shr_proj[i] = lpv_new_reg_shr_proj[i-1]:*(1+(lpv_new_reg_shr_gdp_coeff:*gdp_percapita_growth[i+8]) + (lpv_new_reg_shr_price_coeff:*vehicle_price_proj_r_growth[i+8]))
}

/* (vii) Age distribution of used vehicle registrations*/
/* Model age distribution using possion Lambda = expected age, evolving*/
/* according to assumptions - based on the idea that this is a policy or*/
/* exogenous variable*/

lpv_used_reg_age_hist=J(IL_fleet,veh_ages-1,0)
for (i=1;i<=lpv_types;i++){
lpv_used_reg_age_hist = lpv_reg[1..IL_fleet,(i-1)*veh_ages+2..i*veh_ages] + lpv_used_reg_age_hist
}
lpv_used_reg_hist = rowsum(lpv_used_reg_age_hist)

lpv_used_reg_age_shr_hist = J(IL_fleet,veh_ages-1,0)
for (i=1; i<=IL_fleet;i++){
lpv_used_reg_age_shr_hist[.,i] = lpv_used_reg_age_hist[.,i]:/lpv_used_reg_hist 
}
lpv_used_reg_age_shr_proj = (lpv_used_reg_age_shr_hist\J(PL_fleet+1,veh_ages-1,0))
used_veh_ages = veh_ages_str[2..veh_ages]
used_veh_ave_age_hist = lpv_used_reg_age_shr_hist*used_veh_ages' 
used_veh_age_proj = (used_veh_ave_age_hist\J(31,1,0))

for (i=IL_fleet;i<=TL_fleet;i++){
used_veh_age_proj[i] = used_veh_age_proj[i-1]:*lpv_used_age_g
for (h=1;h<=veh_ages-1;h++){
lpv_used_reg_age_shr_proj[i,h] =poissonp(rnormal(1,1,used_veh_age_proj[i],lpv_used_age_sigma), used_veh_ages[h]-1)
}
}
/*Adjust used shares to account for proportion of new veicles in new*/
/*registrations - in step (ii) used vehicle age distribution sums to one.*/
lpv_used_reg_age_shr_proj = lpv_used_reg_age_shr_proj:*J(1,veh_ages-1,1:-lpv_new_reg_shr_proj)
/* Collect age distributions in single matrix*/
lpv_reg_shr_by_age = (lpv_new_reg_shr_proj,lpv_used_reg_age_shr_proj)

/* (viii) Collect incoming distribution dimensions */
/* NB: that for the time being we assume that alternative fuel vehicles follow the same incoming vehicle age*/
/* disttribution  - as the model is not sensitive to this given the small numbers involved at the current time while further out it is*/
/* accommodating used vehicle supply. Deliberate modelling of this shift left for later work. */

for (i=1; i<=13; i++){
    for (j=IL_fleet+1; j<=TL_fleet; j++){
lpv_reg_shr_proj[j,(i-1)*veh_ages+1..i*veh_ages] =  lpv_reg_shr_by_age[j,.]:*lpv_reg_shr_by_type[j,i]
    }
}
/*
for (i=1; i<=13; i++){
   
lpv_reg_shr_proj[.,(i-1)*veh_ages+1..i*veh_ages] =  lpv_reg_shr_by_age:*lpv_reg_shr_by_type[.,i]
    
}
*/
/* LCV */

/* (a)Scrappage */
lcv_scrap_rate_proj[1..IL_fleet,.]= lcv_scrap_rate
lcv_scrap_constant = (lcv_scrap_rate[19,.]+lcv_scrap_rate[20,.])*0.5
lcv_scrap_rate_proj[IL_fleet..rows(lcv_scrap_rate_proj),.] = J(TL_fleet-IL_fleet+1, 1, lcv_scrap_constant)
lcv_survival_proj = 1:-lcv_scrap_rate_proj



/* lcv_scrap_rate_proj(1:IL_fleet,:,:) = lcv_scrap_rate; */
/* lcv_scrap_constant = (lcv_scrap_rate(8,:,:)+lcv_scrap_rate(9,:,:))*0.5; */
/* lcv_scrap_rate_proj(11:end,:,:) = repmat(lcv_scrap_constant,[32 1 1]); */
/* lcv_survival_proj = 1-lcv_scrap_rate_proj; */

/* (b) Registrations */
/* (i) Preliminaries  */
/* Includes set up for naive forecast if needed (i.e. reg based on history) - not used in the current configuration of the model */
lcv_reg_proj = J(TL_fleet, lcv_types*veh_ages,0)
lcv_reg_proj[1..IL_fleet,.] = lcv_reg
lcv_reg_constant = (lcv_reg[8,.]+lcv_reg[9,.])*0.5
lcv_reg_proj[IL_fleet+1..rows(lcv_reg_proj),.] = J(TL_fleet-IL_fleet, 1, lcv_reg_constant)

lcv_reg_hist_total = rowsum(lcv_reg)
lcv_reg_shr_constant = lcv_reg[5,.]:/ lcv_reg_hist_total[5] /*To be varied by scenario*/
lcv_reg_shr_hist = lcv_reg:/lcv_reg_hist_total 

/*lcv_reg_shock = 1 /*Shocking registrations in a given year*/
lcv_reg_proj(21,6:9,:) = lcv_reg_proj(15,6:9,:)*lcv_reg_shock; /* this isnt used with the impact of the HH model - however it could be moved below to create a bespoke shock outside the HH model*/ */
lcv_proj[1,.] = lcv[1,.] /*initialising projection for year 2000 */
lcv_reg_proj_tot[1,.] = rowsum(lcv_reg[1,.]) /*initialising projection for year 2000 */

/* (ii) Project vehicle sizes: small vs large */
lcv_reg_small_hist = J(TL_fleet,1,0)
lcv_reg_small_hist = rowsum(lcv_reg_proj[.,1..veh_ages])+rowsum(lcv_reg_proj[.,veh_ages+1..2*veh_ages])+rowsum(lcv_reg_proj[.,veh_ages*5+1..6*veh_ages])+rowsum(lcv_reg_proj[.,veh_ages*6+1..veh_ages*7])

lcv_reg_shr_proj = lcv_reg_shr_hist\ J(PL_fleet+1, 1, lcv_reg_shr_constant) /*Constant market share of new registrations by age and type - to be overwritten but available if needed */
lcv_reg_lrg_hist = rowsum(lcv_reg_proj[.,veh_ages*2+1..veh_ages*3])+rowsum(lcv_reg_proj[.,veh_ages*3+1..4*veh_ages])+rowsum(lcv_reg_proj[.,veh_ages*4+1..5*veh_ages])+rowsum(lcv_reg_proj[.,veh_ages*7+1..veh_ages*8]) +rowsum(lcv_reg_proj[.,veh_ages*8+1..veh_ages*9])
/* Calculate historical shars of large vehicles (M,L,XL) */
lcv_reg_lrg_shr_hist = lcv_reg_lrg_hist[1..IL_fleet]:/lcv_reg_hist_total /* Calculate share in total registrations*/
lcv_reg_lrg_shr_proj = (lcv_reg_lrg_shr_hist[1..IL_fleet]\J(PL_fleet+1,1,0)) /*Initialise projection series for large vehicles share of registrations*/
/*exogenous variables for projection*/
lcv_lrg_exog = (price_to_gdp,gdp_vol_fcast)
/*Model-based projections (linear version)*/
lcv_lrg_i = lcv_lrg_exog*lcv_size_beta
/*Transform to log model*/
lcv_lrg_shr_fit = exp(lcv_lrg_i):/(1:+exp(lcv_lrg_i)) 
/*Calcualte growth rate of fitted proportions - to smooth from actuals to*/
/*model results*/
lcv_lrg_shr_fit_growth = J(TL,1,0)
lcv_lrg_shr_fit_growth[2..TL] = diff(lcv_lrg_shr_fit):/lcv_lrg_shr_fit[1..rows(lcv_lrg_shr_fit)-1]
/*Calculate final fitted forecast proportions*/
for (i=IL_fleet+1; i<=TL_fleet; i++) {
lcv_reg_lrg_shr_proj[i] = lcv_reg_lrg_shr_proj[i-1]:*(1:+lcv_lrg_shr_fit_growth[i+8])
}
lcv_reg_small_shr_proj = 1:-lcv_reg_lrg_shr_proj

/* (iii) Alternative fuel vehicles*/
/*Calculates shares based on assumed growth of alternative vehicles*/
/*All alternative vehicles*/
lcv_reg_alt_hist = rowsum(lcv_reg_proj[.,veh_ages*10+1..veh_ages*11])+rowsum(lcv_reg_proj[.,veh_ages*11+1..12*veh_ages])+rowsum(lcv_reg_proj[.,veh_ages*12+1..13*veh_ages]) 
lcv_reg_alt_shr_proj = (lcv_reg_alt_hist[1..IL_fleet]:/lcv_reg_hist_total\J(TL_fleet-IL_fleet,1,0))

/* Hybrid vehicles*/
lcv_reg_hybrid_hist = rowsum(lcv_reg_proj[.,veh_ages*10+1..veh_ages*11])
lcv_reg_hybrid_alt_shr_proj = (lcv_reg_hybrid_hist[1..IL_fleet]:/lcv_reg_alt_hist[1..IL_fleet]\J(TL_fleet-IL_fleet,1,0))
lcv_reg_hybrid_shr_proj = (lcv_reg_hybrid_hist[1..IL_fleet]:/lcv_reg_hist_total\J(TL_fleet-IL_fleet,1,0))

/* Plug-in hybrid vehicles*/
lcv_reg_plugin_hist = rowsum(lcv_reg_proj[.,veh_ages*11+1..veh_ages*12])
lcv_reg_plugin_alt_shr_proj = (lcv_reg_plugin_hist[1..IL_fleet]:/lcv_reg_alt_hist[1..IL_fleet]\J(TL_fleet-IL_fleet,1,0))
lcv_reg_plugin_shr_proj = (lcv_reg_plugin_hist[1..IL_fleet]:/lcv_reg_hist_total\J(TL_fleet-IL_fleet,1,0))
lcv_reg_plugin_alt_shr_proj[11,1] = .01 /*initialising plugin hybrid - seeing as there were none in history*/

/* Electric vehicles*/
lcv_reg_electric_hist = rowsum(lcv_reg_proj[.,veh_ages*12+1..veh_ages*13])
lcv_reg_electric_alt_shr_proj = (lcv_reg_plugin_hist[1..IL_fleet]:/lcv_reg_alt_hist[1..IL_fleet]\J(TL_fleet-IL_fleet,1,0))
lcv_reg_electric_shr_proj = (lcv_reg_electric_hist[1..IL_fleet]:/lcv_reg_hist_total\J(TL_fleet-IL_fleet,1,0))


for (i=IL_fleet+1; i<=TL_fleet;i++){
    lcv_reg_alt_shr_proj[i] = lcv_reg_alt_shr_proj[i-1] + (lcv_alt_target-lcv_reg_alt_shr_proj[i-1])/((1+lcv_alt_S:*exp(-lcv_alt_b:*((i-11)-lcv_alt_T)))^(1/lcv_alt_v))
    
    lcv_reg_plugin_alt_shr_proj[i] = lcv_reg_plugin_alt_shr_proj[i-1] + (lcv_reg_plugin_target_shr-lcv_reg_plugin_alt_shr_proj[i-1])/((1+lcv_alt_S:*exp(-lcv_alt_b:*((i-11)-lcv_plugin_T)))^(1/lcv_alt_v))
    lcv_reg_electric_alt_shr_proj[i] = lcv_reg_electric_alt_shr_proj[i-1] + (lcv_reg_electric_target_shr-lcv_reg_electric_alt_shr_proj[i-1])/((1+lcv_alt_S:*exp(-lcv_alt_b:*((i-11)-lcv_electric_T)))^(1/lcv_alt_v))
    lcv_reg_hybrid_alt_shr_proj[i] = 1-(lcv_reg_plugin_alt_shr_proj[i]+lcv_reg_electric_alt_shr_proj[i])
    
    lcv_reg_hybrid_shr_proj[i]= lcv_reg_hybrid_alt_shr_proj[i]:*lcv_reg_alt_shr_proj[i]
    lcv_reg_plugin_shr_proj[i] = lcv_reg_plugin_alt_shr_proj[i]:*lcv_reg_alt_shr_proj[i]
    lcv_reg_electric_shr_proj[i] = lcv_reg_electric_alt_shr_proj[i]:*lcv_reg_alt_shr_proj[i]
}

/* (iv) Combine projections of small-large-and alternative fuel vehicles*/
/*Subtract alternative vehicle growth from small and large vehicle shares in*/
/*proportion to total vehicles (i.e. size neutral)*/
lcv_small_wght = lcv_reg_small_shr_proj[IL_fleet+1..TL_fleet]
lcv_reg_small_shr_proj[IL_fleet+1..TL_fleet] = lcv_reg_small_shr_proj[IL_fleet+1..TL_fleet] - (lcv_small_wght:*lcv_reg_alt_shr_proj[IL_fleet+1..TL_fleet])
lcv_reg_lrg_shr_proj[IL_fleet+1..TL_fleet] = lcv_reg_lrg_shr_proj[IL_fleet+1..TL_fleet] - ((1:-lcv_small_wght):*lcv_reg_alt_shr_proj[IL_fleet+1..TL_fleet])


/* (v) Calculate shares within each category */
/*i.e. distributions within small and large - being that alternative fuel shares are calculated*/
/*directly by assumption) The target is to fill out the following matrix...*/
lcv_reg_shr_by_type = J(TL_fleet,13,0)

/*Calcuate constant proportions within each size type and replicate*/
lcv_reg_small_constant = (rowsum(lcv_reg[11,1..veh_ages*2]):/lcv_reg_small_hist[11],rowsum(lcv_reg[11,veh_ages*1+1..veh_ages*2]):/lcv_reg_small_hist[11],rowsum(lcv_reg[11,veh_ages*5+1..veh_ages*6]):/lcv_reg_small_hist[11],rowsum(lcv_reg[11,veh_ages*6+1..veh_ages*7]):/lcv_reg_small_hist[11])
lcv_reg_lrg_constant = (rowsum(lcv_reg[11,veh_ages*2+1..veh_ages*3]):/lcv_reg_lrg_hist[11],rowsum(lcv_reg[11,veh_ages*3+1..veh_ages*4]):/lcv_reg_lrg_hist[11],rowsum(lcv_reg[11,veh_ages*4+1..veh_ages*5]):/lcv_reg_lrg_hist[11],rowsum(lcv_reg[11,veh_ages*7+1..veh_ages*8]):/lcv_reg_lrg_hist[11],rowsum(lcv_reg[11,veh_ages*8+1..veh_ages*9]):/lcv_reg_lrg_hist[11],rowsum(lcv_reg[11,veh_ages*9+1..veh_ages*10]):/lcv_reg_lrg_hist[11])

/*Small vehicles*/
lcv_reg_shr_by_type[.,1..2] = lcv_reg_small_shr_proj*lcv_reg_small_constant[.,1..2] /*Petrol*/
lcv_reg_shr_by_type[.,6..7] = lcv_reg_small_shr_proj*lcv_reg_small_constant[.,3..4] /* Diesel*/

/*Large vehicles*/
lcv_reg_shr_by_type[.,3..5] = lcv_reg_lrg_shr_proj*lcv_reg_lrg_constant[.,1..3] /*Petrol*/
lcv_reg_shr_by_type[.,8..10] = lcv_reg_lrg_shr_proj*lcv_reg_lrg_constant[.,4..6] /*Diesel*/

/*Alternative fuel vehicles*/
lcv_reg_shr_by_type[.,11..13] = (lcv_reg_hybrid_shr_proj,lcv_reg_plugin_shr_proj,lcv_reg_electric_shr_proj)

/* (vi) Project shares which are new and used */
/*Share of new vehicles in lcv registrations*/
lcv_new_reg_hist = J(IL_fleet,1,0)
for (h=1; h<=IL_fleet; h++){
	for (j=1; j<=13; j++){

	lcv_new_reg_hist[h] = lcv_reg[h,(j-1)*veh_ages+1] + lcv_new_reg_hist[h]
	}
}
lcv_new_reg_shr_hist = lcv_new_reg_hist:/lcv_reg_hist_total
lcv_new_reg_shr_proj = (lcv_new_reg_shr_hist\J(PL_fleet+1,1,0))

for (i=IL_fleet+1;i<=TL_fleet;i++){
    lcv_new_reg_shr_proj[i] = lcv_new_reg_shr_proj[i-1]:*(1+(lcv_new_reg_shr_gdp_coeff:*gdp_percapita_growth[i+8]) + (lcv_new_reg_shr_price_coeff:*vehicle_price_proj_r_growth[i+8]))
}

/* (vii) Age distribution of used vehicle registrations*/
/* Model age distribution using possion Lambda = expected age, evolving*/
/* according to assumptions - based on the idea that this is a policy or*/
/* exogenous variable*/

lcv_used_reg_age_hist=J(IL_fleet,veh_ages-1,0)
for (i=1;i<=lcv_types;i++){
lcv_used_reg_age_hist = lcv_reg[1..IL_fleet,(i-1)*veh_ages+2..i*veh_ages] + lcv_used_reg_age_hist
}
lcv_used_reg_hist = rowsum(lcv_used_reg_age_hist)

lcv_used_reg_age_shr_hist = J(IL_fleet,veh_ages-1,0)
for (i=1; i<=IL_fleet;i++){
lcv_used_reg_age_shr_hist[.,i] = lcv_used_reg_age_hist[.,i]:/lcv_used_reg_hist 
}
lcv_used_reg_age_shr_proj = (lcv_used_reg_age_shr_hist\J(PL_fleet+1,veh_ages-1,0))
used_veh_ages = veh_ages_str[2..veh_ages]
used_veh_ave_age_hist = lcv_used_reg_age_shr_hist*used_veh_ages' 
used_veh_age_proj = (used_veh_ave_age_hist\J(31,1,0))


for (i=IL_fleet;i<=TL_fleet;i++){
used_veh_age_proj[i] = used_veh_age_proj[i-1]:*lcv_used_age_g
for (h=1;h<=veh_ages-1;h++){
	lcv_used_reg_age_shr_proj[i,h] =poissonp(rnormal(1,1,used_veh_age_proj[i],lcv_used_age_sigma), used_veh_ages[h]-1)
}
}


/*Adjust used shares to account for proportion of new veicles in new*/
/*registrations - in step (ii) used vehicle age distribution sums to one.*/
lcv_used_reg_age_shr_proj = lcv_used_reg_age_shr_proj:*J(1,veh_ages-1,1:-lcv_new_reg_shr_proj)
/* Collect age distributions in single matrix*/
lcv_reg_shr_by_age = (lcv_new_reg_shr_proj,lcv_used_reg_age_shr_proj)

/* (viii) Collect incoming distribution dimensions */
/* NB: that for the time being we assume that alternative fuel vehicles follow the same incoming vehicle age*/
/* disttribution  - as the model is not sensitive to this given the small numbers involved at the current time while further out it is*/
/* accommodating used vehicle supply. Deliberate modelling of this shift left for later work. */

for (i=1; i<=13; i++){
    for (j=IL_fleet+1; j<=TL_fleet; j++){
lcv_reg_shr_proj[j, (i-1)*veh_ages+1..i*veh_ages] =  lcv_reg_shr_by_age[j,.]:*lcv_reg_shr_by_type[j,i]
    }
}

/* 3. MCs */
/* (a)Scrappage */
mc_scrap_rate_proj[1..IL_fleet,.]= mc_scrap_rate
mc_scrap_constant = (mc_scrap_rate[20,.]+mc_scrap_rate[19,.])*0.5
mc_scrap_rate_proj[IL_fleet+1..rows(mc_scrap_rate_proj),.] = J(TL_fleet-IL_fleet, 2, mc_scrap_constant[1..45])
mc_survival_proj = 1:-mc_scrap_rate_proj

/* (b) Registrations */
mc_reg_proj = J(TL_fleet, mc_types*veh_ages,0)
mc_reg_proj[1..IL_fleet,.] = mc_reg
mc_reg_constant = (mc_reg[19,.]+mc_reg[20,.])*0.5
mc_reg_proj[IL_fleet+1..rows(mc_reg_proj),.] = J(TL_fleet-IL_fleet, 1, mc_reg_constant)

mc_reg_hist_total = rowsum(mc_reg)
mc_reg_shr_constant = mc_reg[5,.]:/ mc_reg_hist_total[5] /*To be varied by scenario*/
mc_reg_shr_hist = mc_reg:/mc_reg_hist_total 

mc_proj[1,.] = mc[1,.] /*initialising projection for year 2000 */
mc_reg_proj_tot[1,.] = rowsum(mc_reg[1,.]) /*initialising projection for year 2000 */
mc_reg_shr_proj = J(PL_fleet+1,1,mc_reg_shr_constant)
mc_reg_shr_proj = (mc_reg_shr_hist\ mc_reg_shr_proj)

/* 3. HCVs */
/* (a)Scrappage */
hcv_scrap_rate_proj[1..IL_fleet,.]= hcv_scrap_rate
hcv_scrap_constant = (hcv_scrap_rate[8,.]+hcv_scrap_rate[9,.])*0.5
hcv_scrap_rate_proj[IL_fleet..rows(hcv_scrap_rate_proj),.] = J(TL_fleet-IL_fleet+1, 1, hcv_scrap_constant)
hcv_survival_proj = 1:-hcv_scrap_rate_proj

hcv_scrap_constant = (hcv_scrap_rate[8,.]+hcv_scrap_rate[9,.])*0.5
hcv_scrap_rate_proj[IL_fleet..rows(hcv_scrap_rate_proj),.] = J(TL_fleet-IL_fleet+1, 1, hcv_scrap_constant)
hcv_survival_proj = 1:-hcv_scrap_rate_proj

/* (b) Registrations */
hcv_reg_proj = J(TL_fleet, hcv_types*veh_ages,0)
hcv_reg_proj[1..IL_fleet,.] = hcv_reg
hcv_reg_constant = (hcv_reg[8,.]+hcv_reg[9,.])*0.5
hcv_reg_proj[IL_fleet+1..rows(hcv_reg_proj),.] = J(TL_fleet-IL_fleet, 1, hcv_reg_constant)

hcv_reg_hist_total = rowsum(hcv_reg)
hcv_reg_shr_constant = hcv_reg[5,.]:/ hcv_reg_hist_total[5] /*To be varied by scenario*/
hcv_reg_shr_hist = hcv_reg:/hcv_reg_hist_total 

hcv_proj[1,.] = hcv[1,.] /*initialising projection for year 2000 */
hcv_reg_proj_tot[1,.] = rowsum(hcv_reg[1,.]) /*initialising projection for year 2000 */
hcv_reg_shr_proj = J(PL_fleet+1,1,hcv_reg_shr_constant)
hcv_reg_shr_proj = (hcv_reg_shr_hist\ hcv_reg_shr_proj)

/* 5. BUSs*/

/* (a)Scrappage */
bus_scrap_rate_proj[1..IL_fleet,.]= bus_scrap_rate
bus_scrap_constant = (bus_scrap_rate[8,.]+bus_scrap_rate[9,.])*0.5
bus_scrap_rate_proj[IL_fleet+1..rows(bus_scrap_rate_proj),.] = J(TL_fleet-IL_fleet, 1, bus_scrap_constant)
bus_survival_proj = 1:-bus_scrap_rate_proj

bus_scrap_constant = (bus_scrap_rate[8,.]+bus_scrap_rate[9,.])*0.5
bus_scrap_rate_proj[IL_fleet+1..rows(bus_scrap_rate_proj),.] = J(TL_fleet-IL_fleet, 1, bus_scrap_constant)
bus_survival_proj = 1:-bus_scrap_rate_proj

/* (b) Registrations */
bus_reg_proj = J(TL_fleet, bus_types*veh_ages,0)
bus_reg_proj[1..IL_fleet,.] = bus_reg
bus_reg_constant = (bus_reg[8,.]+bus_reg[9,.])*0.5
bus_reg_proj[IL_fleet+1..rows(bus_reg_proj),.] = J(TL_fleet-IL_fleet, 1, bus_reg_constant)

bus_reg_hist_total = rowsum(bus_reg)
bus_reg_shr_constant = bus_reg[5,.]:/ bus_reg_hist_total[5] /*To be varied by scenario*/
bus_reg_shr_hist = bus_reg:/bus_reg_hist_total 

bus_proj[1,.] = bus[1,.] /*initialising projection for year 2000 */
bus_reg_proj_tot[1,.] = rowsum(bus_reg[1,.]) /*initialising projection for year 2000 */
bus_reg_shr_proj = J(PL_fleet+1,1,bus_reg_shr_constant)
bus_reg_shr_proj = (bus_reg_shr_hist\ bus_reg_shr_proj)

/* PROJECT FLEET NUMBERS */
/* Based on scrappage transition matrix and projected registrations*/

/* 1. LPVs*/
/* veh_demand_growth is calculated from HH_vehicle_demand.do*/

veh_demand_growth_rep = J(1, veh_ages*lpv_types, veh_demand_growth[9..rows(veh_demand_growth)])

for (i=1; i<=TL_fleet-1; i++){
    for (j=1; j<=lpv_types; j++){

        lpv_p_survival[.,(j-1)*veh_ages+1..j*veh_ages]=diag(lpv_survival_proj[i,(j-1)*veh_ages+1..j*veh_ages]) /*Create diagonal matrix of  survival probabilities*/
		T_lpv[.,(j-1)*veh_ages+1..j*veh_ages]=(J(1,veh_ages,0)\lpv_p_survival[1..veh_ages_minus_one,(j-1)*veh_ages+1..j*veh_ages]) /*Create  transition matrix*/
		lpv_proj[i+1,(j-1)*veh_ages+1..j*veh_ages]=(T_lpv[.,(j-1)*veh_ages+1..j*veh_ages]*lpv_proj[i,(j-1)*veh_ages+1..j*veh_ages]')' /*Calculate initial new vehicle stock - before additions/registrations*/	
	}
 lpv_scrap_proj[i+1,.] = lpv_scrap_rate_proj[i+1,.]:*lpv_proj[i,.]  
 lpv_replacement_demand[i+1] = rowsum(lpv_scrap_proj[i+1,.]) /*Calculate replacement demand by age and type and then sum - step two*/
 lpv_new_demand_proj[i+1,.] = veh_demand_growth_rep[i+1,.]:*lpv_proj[i,.] /*Calculate new demand based on HH travel and vehicle model results*/
     for (j=1; j<=lpv_types; j++){

 lpv_new_demand_proj_types[i+1,j]= rowsum(lpv_new_demand_proj[i+1,(j-1)*veh_ages+1..j*veh_ages])
	 }
 lpv_new_demand_proj_tot[i+1] = rowsum(lpv_new_demand_proj_types[i+1,.]) 
 lpv_reg_proj_tot[i+1] = lpv_replacement_demand[i+1]+ lpv_new_demand_proj_tot[i+1]
 lpv_reg_proj[i+1,.]= lpv_reg_proj_tot[i+1]:*lpv_reg_shr_proj[i+1,.]
 lpv_proj[i+1,.]=lpv_proj[i+1,.]+ lpv_reg_proj[i+1,.]
 lpv_scrap_proj[i+1,.] = lpv_scrap_rate_proj[i+1,.]:*lpv_proj[i,.] 
}
for (j=1; j<=veh_ages; j++){
	for (i=1; i<=lpv_types; i++) {
	lpv_proj_all_types[.,j] = lpv_proj_all_types[.,j] + lpv_proj[.,(i-1)*veh_ages+j]
	}
}

lpv_proj= editmissing(lpv_proj,0)
lpv_proj_total = rowsum(lpv_proj)

/* 2. LCVs*/
/* The reason for the drop in figures in 21 is because of veh_demand_growth_rep*/

for (i=1; i<=TL_fleet-1; i++){
    for (j=1; j<=lcv_types; j++){

        lcv_p_survival[.,(j-1)*veh_ages+1..j*veh_ages]=diag(lcv_survival_proj[i,(j-1)*veh_ages+1..j*veh_ages]) /*Create diagonal matrix of  survival probabilities*/
		T_lcv[.,(j-1)*veh_ages+1..j*veh_ages]=(J(1,veh_ages,0)\lcv_p_survival[1..veh_ages_minus_one,(j-1)*veh_ages+1..j*veh_ages]) /*Create  transition matrix*/
		lcv_proj[i+1,(j-1)*veh_ages+1..j*veh_ages]=(T_lcv[.,(j-1)*veh_ages+1..j*veh_ages]*lcv_proj[i,(j-1)*veh_ages+1..j*veh_ages]')' /*Calculate initial new vehicle stock - before additions/registrations*/	
	}
 lcv_scrap_proj[i+1,.] = lcv_scrap_rate_proj[i+1,.]:*lcv_proj[i,.]  
 lcv_replacement_demand[i+1] = rowsum(lcv_scrap_proj[i+1,.]) /*Calculate replacement demand by age and type and then sum - step two*/
 lcv_new_demand_proj[i+1,.] = veh_demand_growth_rep[i+1,.]:*lcv_proj[i,.] /*Calculate new demand based on HH travel and vehicle model results*/
     for (j=1; j<=lcv_types; j++){

 lcv_new_demand_proj_types[i+1,j]= rowsum(lcv_new_demand_proj[i+1,(j-1)*veh_ages+1..j*veh_ages])
	 }
 lcv_new_demand_proj_tot[i+1] = rowsum(lcv_new_demand_proj_types[i+1,.]) 
 lcv_reg_proj_tot[i+1] = lcv_replacement_demand[i+1]+ lcv_new_demand_proj_tot[i+1]
 lcv_reg_proj[i+1,.]= lcv_reg_proj_tot[i+1]:*lcv_reg_shr_proj[i+1,.]
 lcv_proj[i+1,.]=lcv_proj[i+1,.]+ lcv_reg_proj[i+1,.]
 lcv_scrap_proj[i+1,.] = lcv_scrap_rate_proj[i+1,.]:*lcv_proj[i,.] 
}
for (j=1; j<=veh_ages; j++){
	for (i=1; i<=lcv_types; i++) {
	lcv_proj_all_types[.,j] = lcv_proj_all_types[.,j] + lcv_proj[.,(i-1)*veh_ages+j]
	}
}

lcv_proj= editmissing(lcv_proj,0)
lcv_proj_total = rowsum(lcv_proj)

/* 3. MCs*/

mc_demand_growth_rep = J(1, veh_ages*mc_types, veh_demand_growth[9..rows(veh_demand_growth)])

for (i=1; i<=TL_fleet-1; i++){
    for (j=1; j<=mc_types; j++){

        mc_p_survival[.,(j-1)*veh_ages+1..j*veh_ages]=diag(mc_survival_proj[i,(j-1)*veh_ages+1..j*veh_ages]) /*Create diagonal matrix of  survival probabilities*/
	
		T_mc[.,(j-1)*veh_ages+1..j*veh_ages]=(J(1,veh_ages,0)\mc_p_survival[1..veh_ages_minus_one,(j-1)*veh_ages+1..j*veh_ages]) /*Create  transition matrix*/
		mc_proj[i+1,(j-1)*veh_ages+1..j*veh_ages]=(T_mc[.,(j-1)*veh_ages+1..j*veh_ages]*mc_proj[i,(j-1)*veh_ages+1..j*veh_ages]')' /*Calculate initial new vehicle stock - before additions/registrations*/	
	}

 mc_scrap_proj[i+1,.] = mc_scrap_rate_proj[i+1,.]:*mc_proj[i,.]  
 mc_replacement_demand[i+1] = rowsum(mc_scrap_proj[i+1,.]) /*Calculate replacement demand by age and type and then sum - step two*/
 mc_new_demand_proj[i+1,.] = mc_demand_growth_rep[i+1,.]:*mc_proj[i,.] /*Calculate new demand based on HH travel and vehicle model results*/
     for (j=1; j<=mc_types; j++){

 mc_new_demand_proj_types[i+1,j]= rowsum(mc_new_demand_proj[i+1,(j-1)*veh_ages+1..j*veh_ages])
	 }
 mc_new_demand_proj_tot[i+1] = rowsum(mc_new_demand_proj_types[i+1,.]) 
 mc_reg_proj_tot[i+1] = mc_replacement_demand[i+1]+ mc_new_demand_proj_tot[i+1]
 mc_reg_proj[i+1,.]= mc_reg_proj_tot[i+1]:*mc_reg_shr_proj[i+1,.]
 mc_proj[i+1,.]=mc_proj[i+1,.]+ mc_reg_proj[i+1,.]
 mc_scrap_proj[i+1,.] = mc_scrap_rate_proj[i+1,.]:*mc_proj[i,.] 
}
for (j=1; j<=veh_ages; j++){
	for (i=1; i<=mc_types; i++) {
	mc_proj_all_types[.,j] = mc_proj_all_types[.,j] + mc_proj[.,(i-1)*veh_ages+j]
	}
}

mc_proj= editmissing(mc_proj,0)
mc_proj_total = rowsum(mc_proj)

/* 4. HCVs*/

roadfreight_vol_growth_rep = J(1, veh_ages*hcv_types, roadfreight_vol_growth[9..rows(veh_demand_growth)])

for (i=1; i<=TL_fleet-1; i++){
    for (j=1; j<=hcv_types; j++){

        hcv_p_survival[.,(j-1)*veh_ages+1..j*veh_ages]=diag(hcv_survival_proj[i,(j-1)*veh_ages+1..j*veh_ages]) /*Create diagonal matrix of  survival probabilities*/
		T_hcv[.,(j-1)*veh_ages+1..j*veh_ages]=(J(1,veh_ages,0)\hcv_p_survival[1..veh_ages_minus_one,(j-1)*veh_ages+1..j*veh_ages]) /*Create  transition matrix*/
		hcv_proj[i+1,(j-1)*veh_ages+1..j*veh_ages]=(T_hcv[.,(j-1)*veh_ages+1..j*veh_ages]*hcv_proj[i,(j-1)*veh_ages+1..j*veh_ages]')' /*Calculate initial new vehicle stock - before additions/registrations*/	
	}
 hcv_scrap_proj[i+1,.] = hcv_scrap_rate_proj[i+1,.]:*hcv_proj[i,.]  
 hcv_replacement_demand[i+1] = rowsum(hcv_scrap_proj[i+1,.]) /*Calculate replacement demand by age and type and then sum - step two*/
 hcv_new_demand_proj[i+1,.] = roadfreight_vol_growth_rep[i+1,.]:*hcv_proj[i,.] /*Calculate new demand based on HH travel and vehicle model results*/
     for (j=1; j<=hcv_types; j++){

 hcv_new_demand_proj_types[i+1,j]= rowsum(hcv_new_demand_proj[i+1,(j-1)*veh_ages+1..j*veh_ages])
	 }
 hcv_new_demand_proj_tot[i+1] = rowsum(hcv_new_demand_proj_types[i+1,.]) 
 hcv_reg_proj_tot[i+1] = hcv_replacement_demand[i+1]+ hcv_new_demand_proj_tot[i+1]
 hcv_reg_proj[i+1,.]= hcv_reg_proj_tot[i+1]:*hcv_reg_shr_proj[i+1,.]
 hcv_proj[i+1,.]=hcv_proj[i+1,.]+ hcv_reg_proj[i+1,.]
 hcv_scrap_proj[i+1,.] = hcv_scrap_rate_proj[i+1,.]:*hcv_proj[i,.] 
}
for (j=1; j<=veh_ages; j++){
	for (i=1; i<=hcv_types; i++) {
	hcv_proj_all_types[.,j] = hcv_proj_all_types[.,j] + hcv_proj[.,(i-1)*veh_ages+j]
	}
}

hcv_proj= editmissing(hcv_proj,0)
hcv_proj_total = rowsum(hcv_proj)

/* 5. BUSs*/
/* veh_demand_growth is calculated from HH_vehicle_demand.do*/

bus_demand_growth_rep = J(1, veh_ages*bus_types, veh_demand_growth[9..rows(veh_demand_growth)])

for (i=1; i<=TL_fleet-1; i++){
    for (j=1; j<=bus_types; j++){

        bus_p_survival[.,(j-1)*veh_ages+1..j*veh_ages]=diag(bus_survival_proj[i,(j-1)*veh_ages+1..j*veh_ages]) /*Create diagonal matrix of  survival probabilities*/
		T_bus[.,(j-1)*veh_ages+1..j*veh_ages]=(J(1,veh_ages,0)\bus_p_survival[1..veh_ages_minus_one,(j-1)*veh_ages+1..j*veh_ages]) /*Create  transition matrix*/
		bus_proj[i+1,(j-1)*veh_ages+1..j*veh_ages]=(T_bus[.,(j-1)*veh_ages+1..j*veh_ages]*bus_proj[i,(j-1)*veh_ages+1..j*veh_ages]')' /*Calculate initial new vehicle stock - before additions/registrations*/	
	}
 bus_scrap_proj[i+1,.] = bus_scrap_rate_proj[i+1,.]:*bus_proj[i,.]  
 bus_replacement_demand[i+1] = rowsum(bus_scrap_proj[i+1,.]) /*Calculate replacement demand by age and type and then sum - step two*/
 bus_new_demand_proj[i+1,.] = bus_demand_growth_rep[i+1,.]:*bus_proj[i,.] /*Calculate new demand based on HH travel and vehicle model results*/
     for (z=1; z<=bus_types; z++){

 bus_new_demand_proj_types[i+1,z]= rowsum(bus_new_demand_proj[i+1,(z-1)*veh_ages+1..z*veh_ages])
	 }
 bus_new_demand_proj_tot[i+1] = rowsum(bus_new_demand_proj_types[i+1,.]) 
 bus_reg_proj_tot[i+1] = bus_replacement_demand[i+1]+ bus_new_demand_proj_tot[i+1]
 bus_reg_proj[i+1,.]= bus_reg_proj_tot[i+1]:*bus_reg_shr_proj[i+1,.]
 bus_proj[i+1,.]=bus_proj[i+1,.]+ bus_reg_proj[i+1,.]
 bus_scrap_proj[i+1,.] = bus_scrap_rate_proj[i+1,.]:*bus_proj[i,.] 
}
for (h=1; h<=veh_ages; h++){
	for (i=1; i<=bus_types; i++) {
	bus_proj_all_types[.,h] = bus_proj_all_types[.,h] + bus_proj[.,(i-1)*veh_ages+h]
	}
}

bus_proj= editmissing(bus_proj,0)
bus_proj_total = rowsum(bus_proj)

/* ADDITIONAL OUTPUTS AND TOTALS*/

lite_veh_proj_all_types = lcv_proj_all_types + lpv_proj_all_types
lite_veh_proj_total = rowsum(lite_veh_proj_all_types)

/*Electric vehicles (plug in hybrid and electric)*/
elec_veh = rowsum(lpv_proj[.,11*veh_ages+1..13*veh_ages])+rowsum(lcv_proj[.,11*veh_ages+1..13*veh_ages])
elec_veh_shr = elec_veh:/lite_veh_proj_total

lite_alt_fuel_reg_shr = rowsum(lpv_reg_shr_by_type[.,10+1..13])+ rowsum(lcv_reg_shr_by_type[.,10+1..13]):/rowsum(lpv_reg_shr_by_type)+rowsum(lpv_reg_shr_by_type)
lite_alt_fuel_veh = rowsum(lpv_proj[.,10*veh_ages+1..13*veh_ages])+rowsum(lcv_proj[.,10*veh_ages+1..13*veh_ages])
lite_alt_fuel_veh_shr = lite_alt_fuel_veh:/lite_veh_proj_total

tkm_per_hcv = roadfreight_tkm_fcast[9..rows(roadfreight_tkm_fcast)]:/hcv_proj_total

/* LPV - surface plot...*/
/* surf(Fleet_t,veh_ages,lite_veh_proj_all_types');*/
/* xlabel('Years');*/
/* ylabel('Age');*/
/* zlabel('Number of vehicles');*/
/* shading interp;*/

/*Pad shortened output series with zeros to make them full length*/
lite_veh_proj_total = (J(Time_length - TL_fleet,1,0)\lite_veh_proj_total)
hcv_proj_total = (J(Time_length - TL_fleet,1,0)\hcv_proj_total)
mc_proj_total = (J(Time_length - TL_fleet,1,0)\mc_proj_total)
bus_proj_total = (J(Time_length - TL_fleet,1,0)\bus_proj_total)
lite_vehicles_percapita = lite_veh_proj_total:/pop
lite_vehicles_perhousehold = lite_veh_proj_total:/households
fleet_proj_tot = bus_proj_total + mc_proj_total + hcv_proj_total + lite_veh_proj_total

reg_proj_tot = lpv_reg_proj_tot + lcv_reg_proj_tot + hcv_reg_proj_tot + bus_reg_proj_tot + bus_reg_proj_tot
reg_proj_tot = (J(Time_length - TL_fleet,1,0)\reg_proj_tot)

end